/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.api.ui.listeners.DropdownSelectionListener;
import ec.gob.sri.dimm.api.ui.paginas.PaginaBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteExpandableComposite;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.ui.ConstantesUI;
import ec.gob.sri.dimm.ats.ui.asistentes.recaps.AsistenteEdicionRecaps;
import ec.gob.sri.dimm.ats.ui.asistentes.recaps.AsistenteNuevaRecap;
import ec.gob.sri.dimm.ats.ui.dialogos.filtros.IdentificacionRecapsFilter;
import ec.gob.sri.dimm.ats.ui.dialogos.recap.DialogoDetalleAir;
import ec.gob.sri.dimm.ats.ui.editores.EditorATS;
import ec.gob.sri.dimm.ats.ui.util.ValidadorComprobantes;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;
import swing2swt.layout.BorderLayout;

public class PaginaRecaps
extends PaginaBase<EditorATS>
implements VistaModelo<Iva> {
    private DataBindingContext m_bindingContext;
    private Recap recapSeleccionada;
    private DetalleAir detalleSeleccionado;
    private ExpandableComposite xcAir;
    private Iva modeloDatos;
    private Table table_1;
    private Text txtIdentificacion;
    private Button btnBuscar;
    private ToolItem tltmNuevoEstablecimiento;
    private TableViewer tvEstablecimiento;
    private ToolItem tltmEliminarEstablecimiento;
    private ToolItem tltmEditarEstablecimiento;
    private ToolItem tltmNuevoAir;
    private TableViewer tvAir;
    private ToolItem tltmEliminar;
    private ToolItem tltmEditarAir;
    private MenuItem tltmEditarEstablecimiento_1;
    private MenuItem tltmEditarConsumo;
    private MenuItem tltmEditarPago;
    private Menu menuEditar;
    private IdentificacionRecapsFilter filtroRecaps;
    private Table tblEstablecimiento;
    private Label lblRegistros;

    public PaginaRecaps(EditorATS editor, String id, String title) {
        super((EditorBase)editor, id, title);
    }

    public void setModeloDatos(Iva modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setDelayedReflow(true);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new ColumnLayout());
        Section sctnRecaps = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().paintBordersFor((Composite)sctnRecaps);
        sctnRecaps.setText("RECAPS");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnRecaps, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnRecaps.setClient((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        ExpandableComposite xcRecaps = managedForm.getToolkit().createExpandableComposite(composite, 256);
        FormData fd_xcRecaps = new FormData();
        fd_xcRecaps.bottom = new FormAttachment(0, 250);
        fd_xcRecaps.top = new FormAttachment(0, 3);
        fd_xcRecaps.left = new FormAttachment(0, 3);
        xcRecaps.setLayoutData((Object)fd_xcRecaps);
        managedForm.getToolkit().paintBordersFor((Composite)xcRecaps);
        xcRecaps.setText("Informaci\u00f3n Establecimientos");
        Composite cRecap = new Composite((Composite)xcRecaps, 0);
        xcRecaps.setClient((Control)cRecap);
        managedForm.getToolkit().adapt(cRecap);
        managedForm.getToolkit().paintBordersFor(cRecap);
        cRecap.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabecera = new Composite(cRecap, 0);
        cCabecera.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt(cCabecera);
        managedForm.getToolkit().paintBordersFor(cCabecera);
        GridLayout gl_cCabecera = new GridLayout(19, false);
        gl_cCabecera.marginWidth = 0;
        cCabecera.setLayout((Layout)gl_cCabecera);
        ToolBar toolBar = new ToolBar(cCabecera, 0x820000);
        GridData gd_toolBar = new GridData(16384, 4, false, false, 16, 1);
        gd_toolBar.widthHint = 510;
        toolBar.setLayoutData((Object)gd_toolBar);
        managedForm.getToolkit().adapt((Composite)toolBar);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar);
        this.tltmNuevoEstablecimiento = new ToolItem(toolBar, 0);
        this.tltmNuevoEstablecimiento.setText("Nuevo");
        this.tltmEditarEstablecimiento = new ToolItem(toolBar, 4);
        this.tltmEditarEstablecimiento.setText("Editar");
        this.tltmEliminarEstablecimiento = new ToolItem(toolBar, 0);
        this.tltmEliminarEstablecimiento.setText("Eliminar");
        this.menuEditar = new Menu((Control)this.tltmEditarEstablecimiento.getParent().getShell());
        this.tltmEditarEstablecimiento_1 = new MenuItem(this.menuEditar, 0);
        this.tltmEditarEstablecimiento_1.setText("Editar Establecimiento");
        this.tltmEditarConsumo = new MenuItem(this.menuEditar, 0);
        this.tltmEditarConsumo.setText("Editar Consumo");
        this.tltmEditarPago = new MenuItem(this.menuEditar, 0);
        this.tltmEditarPago.setText("Editar Pago");
        DropdownSelectionListener dropListener = new DropdownSelectionListener(this.menuEditar);
        this.tltmEditarEstablecimiento.addSelectionListener((SelectionListener)dropListener);
        Label lblNIdentificacin = new Label(cCabecera, 0);
        GridData gd_lblNIdentificacin = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblNIdentificacin.widthHint = 100;
        lblNIdentificacin.setLayoutData((Object)gd_lblNIdentificacin);
        managedForm.getToolkit().adapt((Control)lblNIdentificacin, true, true);
        lblNIdentificacin.setText("N\u00b0 Identificaci\u00f3n");
        this.txtIdentificacion = new Text(cCabecera, 2048);
        this.txtIdentificacion.setTextLimit(13);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIdentificacion.widthHint = 120;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        managedForm.getToolkit().adapt((Control)this.txtIdentificacion, true, true);
        this.btnBuscar = new Button(cCabecera, 0);
        this.btnBuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaRecaps.this.filtroRecaps.setSearchText(PaginaRecaps.this.txtIdentificacion.getText());
                PaginaRecaps.this.tvEstablecimiento.refresh();
                PaginaRecaps.this.generarAlertaFiltro(PaginaRecaps.this.txtIdentificacion.getText());
            }
        });
        this.btnBuscar.setImage(ResourceManager.getPluginImage((String)"ec.gob.sri.dimm.ats.ui", (String)"iconos/search.png"));
        managedForm.getToolkit().adapt((Control)this.btnBuscar, true, true);
        this.tvEstablecimiento = new TableViewer(cRecap, 67584);
        this.filtroRecaps = new IdentificacionRecapsFilter();
        this.filtroRecaps.setSearchText("");
        this.tvEstablecimiento.addFilter((ViewerFilter)this.filtroRecaps);
        this.tvEstablecimiento.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaRecaps.this.recapSeleccionada = (Recap)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (PaginaRecaps.this.recapSeleccionada != null) {
                    AyudanteExpandableComposite.activar((ExpandableComposite)PaginaRecaps.this.xcAir, (!ValidadorComprobantes.validarEsNotaCreditoDebitoRecap(PaginaRecaps.this.recapSeleccionada.getRecap().getTipoComprobante()) ? 1 : 0) != 0);
                    PaginaRecaps.this.detalleSeleccionado = null;
                    AyudanteViewer.seleccionarElemento((Viewer)PaginaRecaps.this.tvAir, null);
                }
            }
        });
        this.tblEstablecimiento = this.tvEstablecimiento.getTable();
        this.tblEstablecimiento.setLinesVisible(true);
        this.tblEstablecimiento.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblEstablecimiento);
        TableColumn tblclmnTipoEstablecimiento = new TableColumn(this.tblEstablecimiento, 0);
        tblclmnTipoEstablecimiento.setWidth(150);
        tblclmnTipoEstablecimiento.setText("Tipo Id. Establecimiento");
        TableColumn tblclmnNIdEstablecimiento = new TableColumn(this.tblEstablecimiento, 0);
        tblclmnNIdEstablecimiento.setWidth(150);
        tblclmnNIdEstablecimiento.setText("N\u00b0 Id. Establecimiento");
        TableColumn tblclmnTipoDocumento = new TableColumn(this.tblEstablecimiento, 0);
        tblclmnTipoDocumento.setWidth(120);
        tblclmnTipoDocumento.setText("Tipo Documento");
        TableColumn tblclmnNRecap = new TableColumn(this.tblEstablecimiento, 0);
        tblclmnNRecap.setWidth(150);
        tblclmnNRecap.setText("N\u00b0 RECAP");
        TableColumn tblclmnTipoTarjeta = new TableColumn(this.tblEstablecimiento, 0);
        tblclmnTipoTarjeta.setWidth(100);
        tblclmnTipoTarjeta.setText("Tipo Tarjeta");
        TableColumn tblclmnTotalConsumo = new TableColumn(this.tblEstablecimiento, 0);
        tblclmnTotalConsumo.setWidth(100);
        tblclmnTotalConsumo.setText("Total Consumo");
        Composite cRegistros = new Composite(cRecap, 0);
        cRegistros.setLayoutData((Object)"South");
        managedForm.getToolkit().adapt(cRegistros);
        managedForm.getToolkit().paintBordersFor(cRegistros);
        cRegistros.setLayout((Layout)new GridLayout(1, false));
        this.lblRegistros = new Label(cRegistros, 0);
        GridData gd_lblRegistros = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRegistros.widthHint = 500;
        this.lblRegistros.setLayoutData((Object)gd_lblRegistros);
        managedForm.getToolkit().adapt((Control)this.lblRegistros, true, true);
        this.xcAir = managedForm.getToolkit().createExpandableComposite(composite, 512);
        FormData fd_xcAir = new FormData();
        fd_xcAir.top = new FormAttachment((Control)xcRecaps, 10);
        fd_xcAir.bottom = new FormAttachment(0, 400);
        fd_xcAir.left = new FormAttachment(0, 3);
        this.xcAir.setLayoutData((Object)fd_xcAir);
        managedForm.getToolkit().paintBordersFor((Composite)this.xcAir);
        this.xcAir.setText("Retenciones en la Fuente  Impuesto a la Renta");
        Composite composite_1 = managedForm.getToolkit().createComposite((Composite)this.xcAir, 0);
        managedForm.getToolkit().paintBordersFor(composite_1);
        this.xcAir.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabeceraAir = managedForm.getToolkit().createComposite(composite_1, 0);
        cCabeceraAir.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(cCabeceraAir);
        ToolBar toolBar_1 = new ToolBar(cCabeceraAir, 0x820000);
        toolBar_1.setBounds(0, 0, 200, 23);
        managedForm.getToolkit().adapt((Composite)toolBar_1);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_1);
        this.tltmNuevoAir = new ToolItem(toolBar_1, 0);
        this.tltmNuevoAir.setText("Nuevo");
        this.tltmEditarAir = new ToolItem(toolBar_1, 0);
        this.tltmEditarAir.setText("Editar");
        this.tltmEliminar = new ToolItem(toolBar_1, 0);
        this.tltmEliminar.setText("Eliminar");
        this.tvAir = new TableViewer(composite_1, 67584);
        this.tvAir.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaRecaps.this.detalleSeleccionado = (DetalleAir)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.table_1 = this.tvAir.getTable();
        this.table_1.setLinesVisible(true);
        this.table_1.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.table_1);
        TableColumn tblclmnCodRetencin = new TableColumn(this.table_1, 0);
        tblclmnCodRetencin.setWidth(100);
        tblclmnCodRetencin.setText("Cod. Retenci\u00f3n");
        TableColumn tblclmnConceptoRetencin = new TableColumn(this.table_1, 0);
        tblclmnConceptoRetencin.setWidth(320);
        tblclmnConceptoRetencin.setText("Concepto Retenci\u00f3n");
        TableColumn tblclmnBaseImponible = new TableColumn(this.table_1, 0);
        tblclmnBaseImponible.setWidth(115);
        tblclmnBaseImponible.setText("Base Imponible");
        TableColumn tblclmnRetencin = new TableColumn(this.table_1, 0);
        tblclmnRetencin.setWidth(115);
        tblclmnRetencin.setText("% Retenci\u00f3n");
        TableColumn tblclmnValorRetenido = new TableColumn(this.table_1, 0);
        tblclmnValorRetenido.setWidth(123);
        tblclmnValorRetenido.setText("Valor Retenido");
        this.initDataBindings();
        this.btnNuevoRecapClick();
        this.btnEliminarRecapClick();
        this.btnEditarEstablecimiento();
        this.btnEditarConsumo();
        this.btnEditarPago();
        this.btnNuenoAirClick();
        this.btnEliminarAirClick();
        this.btnEditarAirClick();
    }

    private void generarAlertaFiltro(String textoFiltro) {
        if (StringUtil.isNullOrEmpty((String)textoFiltro)) {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FOREGROUND);
            this.lblRegistros.setText(String.format("Total Registros: %d %s", this.modeloDatos.getRecaps().size(), "RECAPS"));
        } else {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FILTRO);
            this.lblRegistros.setText(String.format("N\u00famero de registros filtrados: %d, de un total de %d %s", this.tvEstablecimiento.getTable().getItemCount(), this.modeloDatos.getRecaps().size(), "RECAPS"));
        }
    }

    private void btnNuevoRecapClick() {
        this.tltmNuevoEstablecimiento.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Recap recap = new Recap();
                recap.setPropietario((ObjetoModelo)PaginaRecaps.this.modeloDatos);
                recap.inicializar();
                AsistenteNuevaRecap asistenteRecap = new AsistenteNuevaRecap(recap, false, ((PaginaRecaps)PaginaRecaps.this).modeloDatos.periodo);
                WizardDialog dialogoAsistenteNuevaParticipacion = new WizardDialog(PaginaRecaps.this.getSite().getShell(), (IWizard)asistenteRecap);
                if (dialogoAsistenteNuevaParticipacion.open() == 0) {
                    PaginaRecaps.this.modeloDatos.agregarRecap(recap);
                    ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    PaginaRecaps.this.generarAlertaFiltro(PaginaRecaps.this.txtIdentificacion.getText());
                }
            }
        });
    }

    public void btnEditarEstablecimiento() {
        this.tltmEditarEstablecimiento_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.recapSeleccionada != null) {
                    PaginaRecaps.this.recapSeleccionada.getComprobanteRetencion().setObligatorio(true);
                    Recap copiaEdicion = PaginaRecaps.this.recapSeleccionada.crearCopiaEdicion();
                    AsistenteEdicionRecaps asistenteRecap = new AsistenteEdicionRecaps(copiaEdicion, true, AsistenteEdicionRecaps.SeccionRecap.ESTABLECIMIENTO, ((PaginaRecaps)PaginaRecaps.this).modeloDatos.periodo);
                    WizardDialog dialogoEdicion = new WizardDialog(PaginaRecaps.this.getSite().getShell(), (IWizard)asistenteRecap);
                    if (dialogoEdicion.open() == 0) {
                        PaginaRecaps.this.recapSeleccionada.getEstablecimiento().actualizarInformacion((Sujeto)copiaEdicion.getEstablecimiento());
                        PaginaRecaps.this.recapSeleccionada.getRecap().actualizarInformacion(copiaEdicion.getRecap());
                        PaginaRecaps.this.tvEstablecimiento.refresh();
                        if (ValidadorComprobantes.validarEsNotaCreditoDebitoRecap(PaginaRecaps.this.recapSeleccionada.getRecap().getTipoComprobante())) {
                            PaginaRecaps.this.recapSeleccionada.getDetallesAir().clear();
                            PaginaRecaps.this.tvAir.refresh();
                            AyudanteViewer.seleccionarElemento((Viewer)PaginaRecaps.this.tvEstablecimiento, null);
                        }
                        ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    }
                } else {
                    PaginaRecaps.this.mostrarError("No ha seleccionado una Recap");
                }
            }
        });
    }

    public void btnEditarConsumo() {
        this.tltmEditarConsumo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.recapSeleccionada != null) {
                    Recap copiaEdicion = PaginaRecaps.this.recapSeleccionada.crearCopiaEdicion();
                    AsistenteEdicionRecaps asistenteRecap = new AsistenteEdicionRecaps(copiaEdicion, true, AsistenteEdicionRecaps.SeccionRecap.CONSUMO, ((PaginaRecaps)PaginaRecaps.this).modeloDatos.periodo);
                    WizardDialog dialogoEdicion = new WizardDialog(PaginaRecaps.this.getSite().getShell(), (IWizard)asistenteRecap);
                    if (dialogoEdicion.open() == 0) {
                        PaginaRecaps.this.recapSeleccionada.getConsumo().actualizarInformacion(copiaEdicion.getConsumo());
                        PaginaRecaps.this.tvEstablecimiento.refresh();
                        ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    }
                } else {
                    PaginaRecaps.this.mostrarError("No ha seleccionado una Recap");
                }
            }
        });
    }

    public void btnEditarPago() {
        this.tltmEditarPago.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.recapSeleccionada != null) {
                    Recap copiaEdicion = PaginaRecaps.this.recapSeleccionada.crearCopiaEdicion();
                    AsistenteEdicionRecaps asistenteRecap = new AsistenteEdicionRecaps(copiaEdicion, true, AsistenteEdicionRecaps.SeccionRecap.PAGO_LOCAL, ((PaginaRecaps)PaginaRecaps.this).modeloDatos.periodo);
                    WizardDialog dialogoEdicion = new WizardDialog(PaginaRecaps.this.getSite().getShell(), (IWizard)asistenteRecap);
                    if (dialogoEdicion.open() == 0) {
                        PaginaRecaps.this.recapSeleccionada.getPagoLocalExterior().actualizarInformacion(copiaEdicion.getPagoLocalExterior());
                        PaginaRecaps.this.recapSeleccionada.getComprobanteRetencion().actualizarInformacion((Comprobante)copiaEdicion.getComprobanteRetencion());
                        PaginaRecaps.this.tvEstablecimiento.refresh();
                        ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    }
                } else {
                    PaginaRecaps.this.mostrarError("No ha seleccionado una Recap");
                }
            }
        });
    }

    private void btnEliminarRecapClick() {
        this.tltmEliminarEstablecimiento.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.recapSeleccionada != null && PaginaRecaps.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaRecaps.this.modeloDatos.eliminarRecap(PaginaRecaps.this.recapSeleccionada)) {
                    PaginaRecaps.this.recapSeleccionada = null;
                    ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    PaginaRecaps.this.generarAlertaFiltro(PaginaRecaps.this.txtIdentificacion.getText());
                }
            }
        });
    }

    private void btnNuenoAirClick() {
        this.tltmNuevoAir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.recapSeleccionada != null) {
                    DetalleAir detalleAir = new DetalleAir();
                    detalleAir.setPropietario((ObjetoModelo)PaginaRecaps.this.recapSeleccionada);
                    if (PaginaRecaps.this.abrirDialogoAIR(detalleAir, false)) {
                        PaginaRecaps.this.recapSeleccionada.agregarDetallesAir(detalleAir);
                        ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    }
                } else {
                    PaginaRecaps.this.mostrarAdvertencia("No ha seleccionado una Recap para ingresar un detalle de retenci\u00f3n");
                }
            }
        });
    }

    private void btnEliminarAirClick() {
        this.tltmEliminar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.recapSeleccionada != null && PaginaRecaps.this.detalleSeleccionado != null && PaginaRecaps.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaRecaps.this.recapSeleccionada.eliminarDetallesAir(PaginaRecaps.this.detalleSeleccionado)) {
                    PaginaRecaps.this.detalleSeleccionado = null;
                    ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                }
            }
        });
    }

    private void btnEditarAirClick() {
        this.tltmEditarAir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRecaps.this.detalleSeleccionado != null) {
                    DetalleAir copiaEdicion = PaginaRecaps.this.detalleSeleccionado.crearCopiaEdicion();
                    if (PaginaRecaps.this.abrirDialogoAIR(copiaEdicion, true)) {
                        PaginaRecaps.this.detalleSeleccionado.actualizarInformacion(copiaEdicion);
                        PaginaRecaps.this.tvAir.refresh();
                        ((EditorATS)PaginaRecaps.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRecaps.this.modeloDatos);
                    }
                } else {
                    PaginaRecaps.this.mostrarAdvertencia("No ha seleccionado una Retenci\u00f3n para editar");
                }
            }
        });
    }

    private boolean abrirDialogoAIR(DetalleAir modeloDialogo, boolean editando) {
        ArrayList<String> codigosComp = new ArrayList<String>();
        for (DetalleAir detalle : this.recapSeleccionada.getDetallesAir()) {
            codigosComp.add(detalle.getConceptoRetencion());
        }
        DialogoDetalleAir dialogo = new DialogoDetalleAir(this.getSite(), editando, codigosComp, this.modeloDatos.periodo, this.modeloDatos.getDatosDeclaracion().getMicro(), this.modeloDatos.getFechaRegistroContableSeleccionada());
        dialogo.setModeloDatos(modeloDialogo);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Recap.class, (String[])new String[]{"establecimiento.descripcionTipoIdentificacion", "establecimiento.identificacion", "recap.descripcionTipoComprobante", "recap.numeroRecap", "recap.descripcionTarjetaCredito", "consumo.totalConsumo", "consumo.montoIva"});
        this.tvEstablecimiento.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tvEstablecimiento.setContentProvider((IContentProvider)listContentProvider);
        IObservableList recapsModeloDatosObserveList = BeanProperties.list((String)"recaps").observe((Object)this.modeloDatos);
        this.tvEstablecimiento.setInput((Object)recapsModeloDatosObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_1 = BeansObservables.observeMaps((IObservableSet)listContentProvider_1.getKnownElements(), DetalleAir.class, (String[])new String[]{"conceptoRetencion", "descripcionConcepto", "baseImponibleRenta", "porcentajeRetencion", "valorRetenido"});
        this.tvAir.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_1));
        this.tvAir.setContentProvider((IContentProvider)listContentProvider_1);
        IViewerObservableValue observeSingleSelectionTvEstablecimiento = ViewerProperties.singleSelection().observe((Viewer)this.tvEstablecimiento);
        IObservableList tvEstablecimientoDetallesAirObserveDetailList = BeanProperties.list(Recap.class, (String)"detallesAir", DetalleAir.class).observeDetail((IObservableValue)observeSingleSelectionTvEstablecimiento);
        this.tvAir.setInput((Object)tvEstablecimientoDetallesAirObserveDetailList);
        this.generarAlertaFiltro(this.txtIdentificacion.getText());
        return bindingContext;
    }
}

